#include "ScreenQuadPS_Rm.hlsl"

float domainMax()
{
    return smoothstep(0.5, 0.75, SequenceRatio) * LedCubeSideMinusOne; 
}

float4 main( PS_INPUT input) : SV_Target
{
      class StartDomain : LedDomain 
    { 
       bool IsOutside(in float3 p)
        {
            return any(p > 1. + domainMax()) || any(p < 0 );
        }
    } startDomain;

    class Emtpyscene : IntensityProvider 
    { 
        float IntensityAt(float3 p) 
        { 
            return SequenceRatio*2-1;
          
        }
    } emtpyscene;

    class Cam : CamAnimator
    {
         float2x3 GetRays()
         {
            // UV --> input.Text.xy e [0 1]
            /*
            o---------X
            |
            |
            |
            |
            Y
            */

                      // Pixel position
            float2 pixel = 2.0 * (input.Tex.xy  - float2( 0.5, 0.5 ) );
                // pixel.xy e [-1 1], same orientation
                //Let's move in view space, right handed (to fiz cross product errors
            float  offset =smoothstep(0.75, 1., SequenceRatio) * HalfLedCubeSide;
            float3 rayOrigin    = float3(0.5 + offset,  0.75 + offset, 1 + domainMax() + offset*1.1);
            float3 rayDirection = normalize(float3(pixel.x * ScreenRatio, -pixel.y, -1));
    

            float2x3 array = {rayOrigin, rayDirection};

            return array;
         }
    } cam;
    


   
   return rayMarcher(cam, emtpyscene, startDomain);
}